(function() {

	// Load plugin specific language pack
	tinymce.PluginManager.requireLangPack('upload', "en");

	tinymce.create('tinymce.plugins.UploadPlugin', {
		/**
		 * Initializes the plugin, this will be executed after the plugin has been created.
		 * This call is done before the editor instance has finished it's initialization so use the onInit event
		 * of the editor instance to intercept that event.
		 *
		 * @param {tinymce.Editor} ed Editor instance that the plugin is initialized in.
		 * @param {string} url Absolute URL to where the plugin is located.
		 */
		init : function(ed, url) {
			// Register the command so that it can be invoked by using tinyMCE.activeEditor.execCommand('mceExample');
			ed.addCommand('mceUpload', function() {
/*
				if ( !('trigger' in arguments.callee) ) {
					var id = 'tinymce_file_picker' + ~new Date;
					arguments.callee.trigger = new Element('a', {id: id, href: 'javascript:void(null);'});
				}
*/
				var picker = new vivvo.controls.filePicker(null,
					{
						search_dir: 'files/',
						dir_tree_root: 'files/',
						search_ext: 'jpg,png,gif,jpeg',
						upload: true,
						relative: true,
						butonLabel: 'Select image',
						noneSelected: 'No image selected',
						onFileSelected: function(file) {
							var el = ed.selection.getNode();
							if (el && el.nodeName == 'IMG') {
								ed.dom.setAttribs(el, {src: vivvo.url + 'files.php?file=' + file});
							} else {
								ed.execCommand('mceInsertContent', false, '<img id="__mce_tmp" />', {skip_undo : 1});
								ed.dom.setAttribs('__mce_tmp', {src: vivvo.url + 'files.php?file=' + file});
								ed.dom.setAttrib('__mce_tmp', 'id', '');
								ed.undoManager.add();
							}
						}
					}
				);

				picker.modal.open();
			});

			// Register example button
			ed.addButton('upload', {
				title : 'upload',
				cmd : 'mceUpload',
				image : url + '/img/upload.gif'
			});

			// Add a node change handler, selects the button in the UI when a image is selected
			ed.onNodeChange.add(function(ed, cm, n) {
				cm.setActive('upload', n.nodeName == 'IMG');
			});
		},

		/**
		 * Creates control instances based in the incomming name. This method is normally not
		 * needed since the addButton method of the tinymce.Editor class is a more easy way of adding buttons
		 * but you sometimes need to create more complex controls like listboxes, split buttons etc then this
		 * method can be used to create those.
		 *
		 * @param {String} n Name of the control to create.
		 * @param {tinymce.ControlManager} cm Control manager to use inorder to create new control.
		 * @return {tinymce.ui.Control} New control instance or null if no control was created.
		 */
		/*createControl : function(n, cm) {
		switch (cm) {
			case "template":
				return tinyMCE.getButtonHTML(cn, 'lang_template_desc', '{$pluginurl}/images/template.gif', 'mceTemplate', true);
		}
		},*/

		/**
		 * Returns information about the plugin as a name/value array.
		 * The current keys are longname, author, authorurl, infourl and version.
		 *
		 * @return {Object} Name/value array containing information about the plugin.
		 */
		getInfo : function() {
			return {
				longname : 'Example plugin',
				author : 'Some author',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example',
				version : "1.0"
			};
		}
	});

	// Register plugin
	tinymce.PluginManager.add('upload', tinymce.plugins.UploadPlugin);
})();
